function L = Coleski( A )

% nadjimo dimenziju matrice A
[m, n] = size( A );

% ISPITIVANjE GRESAKA
% ako su dimenzije matrice razlicite(ako nije kvadratna)
if m ~= n
    error( 'GRESKA: Matrica mora da bude kvadratna!!!' )
% ako je matrica singularna
elseif abs( det( A ) ) <= eps
    error( 'GRESKA: Matrica mora da bude regularna!!!' )
else 
    % ispitujemo da li je matrica simetricna
    B = A';
    for i = 1 : m
        for j = 1 : m
            if A( i, j ) ~= B( i, j )
                  error( 'GRESKA: Matrica mora da bude simetricna!!!' )
            end
        end
    end
    % ispitujemo pozitivnu definitnost matrice
    [Lp, p] = chol( A );
    if p ~= 0
        error( 'GRESKA: Matrica mora da bude pozitivno definitna!!!' )
    end
end

% ODREDjUJEMO MATRICU L
% za pocetak popunimo matricu nulama
L = zeros( m, m );

% odredimo element na mestu (1, 1)
L( 1, 1 ) = sqrt( A( 1, 1 ) );

% odredjujemo prvu kolonu matrice L
for i = 2 : m
    L( i, 1 ) = A( i, 1 ) / L( 1, 1 );
end

% odredjujemo ostatak matrice
for j = 2 : m
    % odredjujemo element na glavnoj dijagonali na mestu (j, j)
    k = 1 : j - 1;
    L( j, j ) = sqrt( A( j, j ) - sum( L( j, k ) .^ 2 ) );
    % odredjujemo ostatak j-te kolone
    for i = j + 1 : m
        k = 1 : i - 1;
        L( i, j ) = ( A( i, j ) - sum( L( i, k ) .* L( j, k ) ) ) / L( j, j );
    end
end